//
//  table__n_a_m_e.h
//  GSFontTools
//
//  Created by Georg Seifert on 25.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/TTable.h>
@class TTNameRecord;

typedef enum : uint16_t {
	GSNameIdCopyrightNotice = 0,
	GSNameIdFamilyName = 1,
	GSNameIdSubfamilyName = 2,
	GSNameIdUniqueFontIdentifier = 3,
	GSNameIdFullFontName = 4,
	GSNameIdVersionString = 5,
	GSNameIdPostScriptName = 6,
	GSNameIdTrademark = 7,
	GSNameIdManufacturer = 8,
	GSNameIdDesigner = 9,
	GSNameIdDescription = 10,
	GSNameIdVendorURL = 11,
	GSNameIdDesignerURL = 12,
	GSNameIdLicense = 13,
	GSNameIdLicenseURL = 14,
	GSNameIdReserved = 15,
	GSNameIdTypographicFamilyName = 16,
	GSNameIdTypographicSubfamilyName = 17,
	GSNameIdCompatibleFull = 18,
	GSNameIdSampleText = 19,
	GSNameIdPostScriptCIDFindfontName = 20,
	GSNameIdWWSFamilyName = 21,
	GSNameIdWWSSubfamilyName = 22,
	GSNameIdLightBackgroundPalette = 23,
	GSNameIdDarkBackgroundPalette = 24,
	GSNameIdVariationsPostScriptNamePrefix = 25,
} GSNameIdNames;

typedef enum : uint16_t {
	GSNamePlatformUnicode = 0,
	GSNamePlatformMacintosh = 1,
	GSNamePlatformISO = 2,
	GSNamePlatformWindows = 3,
	GSNamePlatformUndefined = 0xffff,
} GSNamePlatform;

typedef enum : uint16_t {
	GSNameEncodingUnicode1_0 = 0,						// Unicode 1.0 semantics
	GSNameEncodingUnicode1_1 = 1,						// Unicode 1.1 semantics
	GSNameEncodingUnicodeISO_IEC = 2,					// ISO/IEC 10646 semantics
	GSNameEncodingUnicode2_0_BMP = 3,					// Unicode 2.0 and onwards semantics, Unicode BMP only ('cmap' subtable formats 0, 4, 6).
	GSNameEncodingUnicode2_0 = 4,						// Unicode 2.0 and onwards semantics, Unicode full repertoire ('cmap' subtable formats 0, 4, 6, 10, 12).
	GSNameEncodingUnicodeUnicodeVariationSequences = 5, // Unicode Variation Sequences ('cmap' subtable format 14).
	GSNameEncodingUnicodeFull = 6,						// Unicode full repertoire ('cmap' subtable formats 0, 4, 6, 10, 12, 13).

	GSNameEncodingWindowsSymbol = 0,
	GSNameEncodingWindowsUnicode = 1,
	GSNameEncodingWindowsShiftJIS = 2,
	GSNameEncodingWindowsPRC = 3,
	GSNameEncodingWindowsBig5 = 4,
	GSNameEncodingWindowsWansung = 5,
	GSNameEncodingWindowsJohab = 6,
	GSNameEncodingWindowsUnicodeFull = 10,
	GSNameEncodingMacRoman = kTextEncodingMacRoman, // use the kTextEncoding… constants for the rest

	GSNameEncodingUndefined = 0xffff, // used for querying unicode cmap
} GSNameEncoding;

typedef enum : uint16_t {
	GSNameLanguageNone = 0, // used in cmap
	GSNameLanguageWindowsEnglishUS = 0x409,
	GSNameLanguageWindowsGerman = 0x407,
	GSNameLanguageWindowsJapanese = 0x411,
	GSNameLanguageWindowsArabic = 0xc01,
	GSNameLanguageWindowsSpanish = 0xc0a,
	GSNameLanguageWindowsChineseSimplified = 0x7804,
	GSNameLanguageWindowsChineseTraditional = 0x7C04,
	GSNameLanguageWindowsChineseChina = 0x0804,
	GSNameLanguageWindowsChineseSingapore = 0x1004,
	GSNameLanguageWindowsChineseHongKong = 0x0C04,
	GSNameLanguageWindowsChineseMacao = 0x1404,
	GSNameLanguageWindowsChineseTaiwan = 0x0404,
	GSNameLanguageMacEnglish = 0,
	GSNameLanguageMacFrench = 1,
	GSNameLanguageMacGerman = 2,
	GSNameLanguageMacItalian = 3,
	GSNameLanguageMacDutch = 4,
	GSNameLanguageMacSwedish = 5,
	GSNameLanguageMacSpanish = 6,
	GSNameLanguageMacDanish = 7,
	GSNameLanguageMacPortuguese = 8,
	GSNameLanguageMacNorwegian = 9,
	GSNameLanguageMacHebrew = 10,
	GSNameLanguageMacJapanese = 11,
	GSNameLanguageMacArabic = 12,
	GSNameLanguageMacFinnish = 13,
	GSNameLanguageMacGreek = 14,
	GSNameLanguageMacIcelandic = 15,
	GSNameLanguageMacMaltese = 16,
	GSNameLanguageMacTurkish = 17,
	GSNameLanguageMacCroatian = 18,
	GSNameLanguageMacChineseTraditional = 19,
	GSNameLanguageMacUrdu = 20,
	GSNameLanguageMacHindi = 21,
	GSNameLanguageMacThai = 22,
	GSNameLanguageMacKorean = 23,
	GSNameLanguageMacLithuanian = 24,
	GSNameLanguageMacPolish = 25,
	GSNameLanguageMacHungarian = 26,
	GSNameLanguageMacEstonian = 27,
	GSNameLanguageMacLatvian = 28,
	GSNameLanguageMacSami = 29,
	GSNameLanguageMacFaroese = 30,
	GSNameLanguageMacFarsi = 31,
	GSNameLanguageMacRussian = 32,
	GSNameLanguageMacChineseSimplified = 33,
	GSNameLanguageMacFlemish = 34,
	GSNameLanguageMacIrishGaelic = 35,
	GSNameLanguageMacAlbanian = 36,
	GSNameLanguageMacRomanian = 37,
	GSNameLanguageMacCzech = 38,
	GSNameLanguageMacSlovak = 39,
	GSNameLanguageMacSlovenian = 40,
	GSNameLanguageMacYiddish = 41,
	GSNameLanguageMacSerbian = 42,
	GSNameLanguageMacMacedonian = 43,
	GSNameLanguageMacBulgarian = 44,
	GSNameLanguageMacUkrainian = 45,
	GSNameLanguageMacByelorussian = 46,
	GSNameLanguageMacUzbek = 47,
	GSNameLanguageMacKazakh = 48,
	GSNameLanguageMacAzerbaijaniCyrillic = 49,
	GSNameLanguageMacAzerbaijaniArabic = 50,
	GSNameLanguageMacArmenian = 51,
	GSNameLanguageMacGeorgian = 52,
	GSNameLanguageMacMoldavian = 53,
	GSNameLanguageMacKirghiz = 54,
	GSNameLanguageMacTajiki = 55,
	GSNameLanguageMacTurkmen = 56,
	GSNameLanguageMacMongolianMongolian = 57,
	GSNameLanguageMacMongolianCyrillic = 58,
	GSNameLanguageMacPashto = 59,
	GSNameLanguageMacKurdish = 60,
	GSNameLanguageMacKashmiri = 61,
	GSNameLanguageMacSindhi = 62,
	GSNameLanguageMacTibetan = 63,
	GSNameLanguageMacNepali = 64,
	GSNameLanguageMacSanskrit = 65,
	GSNameLanguageMacMarathi = 66,
	GSNameLanguageMacBengali = 67,
	GSNameLanguageMacAssamese = 68,
	GSNameLanguageMacGujarati = 69,
	GSNameLanguageMacPunjabi = 70,
	GSNameLanguageMacOriya = 71,
	GSNameLanguageMacMalayalam = 72,
	GSNameLanguageMacKannada = 73,
	GSNameLanguageMacTamil = 74,
	GSNameLanguageMacTelugu = 75,
	GSNameLanguageMacSinhalese = 76,
	GSNameLanguageMacBurmese = 77,
	GSNameLanguageMacKhmer = 78,
	GSNameLanguageMacLao = 79,
	GSNameLanguageMacVietnamese = 80,
	GSNameLanguageMacIndonesian = 81,
	GSNameLanguageMacTagalog = 82,
	GSNameLanguageMacMalayRoman = 83,
	GSNameLanguageMacMalayArabic = 84,
	GSNameLanguageMacAmharic = 85,
	GSNameLanguageMacTigrinya = 86,
	GSNameLanguageMacGalla = 87,
	GSNameLanguageMacSomali = 88,
	GSNameLanguageMacSwahili = 89,
	GSNameLanguageMacKinyarwandaRuanda = 90,
	GSNameLanguageMacRundi = 91,
	GSNameLanguageMacNyanjaChewa = 92,
	GSNameLanguageMacMalagasy = 93,
	GSNameLanguageMacEsperanto = 94,
	GSNameLanguageMacWelsh = 128,
	GSNameLanguageMacBasque = 129,
	GSNameLanguageMacCatalan = 130,
	GSNameLanguageMacLatin = 131,
	GSNameLanguageMacQuechua = 132,
	GSNameLanguageMacGuarani = 133,
	GSNameLanguageMacAymara = 134,
	GSNameLanguageMacTatar = 135,
	GSNameLanguageMacUighur = 136,
	GSNameLanguageMacDzongkha = 137,
	GSNameLanguageMacJavaneseRoman = 138,
	GSNameLanguageMacSundaneseRoman = 139,
	GSNameLanguageMacGalician = 140,
	GSNameLanguageMacAfrikaans = 141,
	GSNameLanguageMacBreton = 142,
	GSNameLanguageMacInuktitut = 143,
	GSNameLanguageMacScottishGaelic = 144,
	GSNameLanguageMacManxGaelic = 145,
	GSNameLanguageMacIrishGaelicDotted = 146,
	GSNameLanguageMacTongan = 147,
	GSNameLanguageMacGreekPolytonic = 148,
	GSNameLanguageMacGreenlandic = 149,
	GSNameLanguageMacAzerbaijaniRoman = 150,
	GSNameLanguageUndefined = 0xffff,
} GSNameLanguage;

typedef struct {
	// big endian
	GSNamePlatform platformID;
	GSNameEncoding platEncID;
	GSNameLanguage langID;
	GSNameIdNames nameID;
	uint16_t length;
	uint16_t offset;
} nameRecordFormat;

@interface table__n_a_m_e : TTable {
	NSMutableArray *_names;
}
@property (retain, nonatomic) NSMutableArray<TTNameRecord *> *names;

- (NSArray<TTNameRecord *> *)namesForId:(GSNameIdNames)nameID;

- (NSArray<TTNameRecord *> *)sortedNameRecordsForId:(GSNameIdNames)nameID;

- (TTNameRecord *)nameForNameID:(GSNameIdNames)nameID platformID:(GSNamePlatform)platformID platEncID:(GSNameEncoding)platEncID langID:(GSNameLanguage)langID;

- (TTNameRecord *)nameRecordForString:(NSString *)name platformID:(GSNamePlatform)platformID platEncID:(GSNameEncoding)platEncID langID:(GSNameLanguage)langID;

- (NSString *)bestNameForId:(GSNameIdNames)nameID;

- (void)setName:(NSString *)name nameID:(GSNameIdNames)nameID;

- (void)setName:(NSString *)name nameID:(GSNameIdNames)nameID platformID:(GSNamePlatform)platformID platEncID:(GSNameEncoding)platEncID langID:(GSNameLanguage)langID;

- (GSNameIdNames)maxNameID;

- (void)removeNameID:(GSNameIdNames)nameID platformID:(GSNamePlatform)platformID platEncID:(GSNameEncoding)platEncID langID:(GSNameLanguage)langID;

- (void)removeNameID:(GSNameIdNames)nameID;

- (NSUInteger)addName:(NSString *)name __attribute((deprecated("use method `addPresentationName:` instead")));

- (GSNameIdNames)addPresentationName:(NSString *)name;

@end

@interface TTNameRecord : NSObject {
	GSNameIdNames _nameID;
	GSNamePlatform _platformID;
	GSNameEncoding _platEncID;
	GSNameLanguage _langID;
	NSString *_string;
	NSData *_data;
}
@property (nonatomic) GSNameIdNames nameID;
@property (nonatomic) GSNamePlatform platformID;
@property (nonatomic) GSNameEncoding platEncID;
@property (nonatomic) GSNameLanguage langID;
@property (retain, nonatomic) NSString *string;
@property (retain, nonatomic) NSData *data;

- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;

@end
